/*___________________________________________________________________________
 |                                                                           |
 |   Constants and Globals                                                   |
 |___________________________________________________________________________|
*/
extern Flag GsmEfr_Overflow;
extern Flag GsmEfr_Carry;

#define MAX_32 (Word32)0x7fffffffL
#define MIN_32 (Word32)0x80000000L

#define MAX_16 (Word16)0x7fff
#define MIN_16 (Word16)0x8000

/*___________________________________________________________________________
 |                                                                           |
 |   Prototypes for basic arithmetic operators                               |
 |___________________________________________________________________________|
*/

Word16 GsmEfr_add (Word16 var1, Word16 var2);    /* Short GsmEfr_add,           1   */
Word16 GsmEfr_sub (Word16 var1, Word16 var2);    /* Short GsmEfr_sub,           1   */
Word16 GsmEfr_abs_s (Word16 var1);               /* Short abs,           1   */
Word16 GsmEfr_shl (Word16 var1, Word16 var2);    /* Short shift left,    1   */
Word16 GsmEfr_shr (Word16 var1, Word16 var2);    /* Short shift right,   1   */
Word16 GsmEfr_mult (Word16 var1, Word16 var2);   /* Short GsmEfr_mult,          1   */
Word32 GsmEfr_L_mult (Word16 var1, Word16 var2); /* Long GsmEfr_mult,           1   */
Word16 GsmEfr_negate (Word16 var1);              /* Short GsmEfr_negate,        1   */
Word16 GsmEfr_extract_h (Word32 L_var1);         /* Extract high,        1   */
Word16 GsmEfr_extract_l (Word32 L_var1);         /* Extract low,         1   */
Word16 GsmEfr_gsm_round (Word32 L_var1);             /* Round,               1   */
Word32 GsmEfr_L_mac (Word32 L_var3, Word16 var1, Word16 var2);   /* Mac,  1  */
Word32 GsmEfr_L_msu (Word32 L_var3, Word16 var1, Word16 var2);   /* Msu,  1  */
Word32 GsmEfr_L_macNs (Word32 L_var3, Word16 var1, Word16 var2); /* Mac without
                                                             sat, 1   */
Word32 GsmEfr_L_msuNs (Word32 L_var3, Word16 var1, Word16 var2); /* Msu without
                                                             sat, 1   */
Word32 GsmEfr_L_add (Word32 L_var1, Word32 L_var2);    /* Long GsmEfr_add,        2 */
Word32 GsmEfr_L_sub (Word32 L_var1, Word32 L_var2);    /* Long GsmEfr_sub,        2 */
Word32 GsmEfr_L_add_c (Word32 L_var1, Word32 L_var2);  /* Long GsmEfr_add with c, 2 */
Word32 GsmEfr_L_sub_c (Word32 L_var1, Word32 L_var2);  /* Long GsmEfr_sub with c, 2 */
Word32 GsmEfr_L_negate (Word32 L_var1);                /* Long GsmEfr_negate,     2 */
Word16 GsmEfr_mult_r (Word16 var1, Word16 var2);       /* Mult with round, 2 */
Word32 GsmEfr_L_shl (Word32 L_var1, Word16 var2);      /* Long shift left, 2 */
Word32 GsmEfr_L_shr (Word32 L_var1, Word16 var2);      /* Long shift right, 2*/
Word16 GsmEfr_shr_r (Word16 var1, Word16 var2);        /* Shift right with
                                                   round, 2           */
Word16 GsmEfr_mac_r (Word32 L_var3, Word16 var1, Word16 var2); /* Mac with
                                                           rounding,2 */
Word16 GsmEfr_msu_r (Word32 L_var3, Word16 var1, Word16 var2); /* Msu with
                                                           rounding,2 */
Word32 GsmEfr_L_deposit_h (Word16 var1);        /* 16 bit var1 -> MSB,     2 */
Word32 GsmEfr_L_deposit_l (Word16 var1);        /* 16 bit var1 -> LSB,     2 */

Word32 GsmEfr_L_shr_r (Word32 L_var1, Word16 var2); /* Long shift right with
                                                round,  3             */
Word32 GsmEfr_L_abs (Word32 L_var1);            /* Long abs,              3  */
Word32 GsmEfr_L_sat (Word32 L_var1);            /* Long saturation,       4  */
Word16 GsmEfr_norm_s (Word16 var1);             /* Short norm,           15  */
Word16 GsmEfr_div_s (Word16 var1, Word16 var2); /* Short division,       18  */
Word16 GsmEfr_norm_l (Word32 L_var1);           /* Long norm,            30  */   

