/*############################################################################
#
# Copyright (c) 2000-2016 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
############################################################################*/

/*
 * vqbldcfg.h
 *
 * VQmon Build Target-Specific Configuration
 *
 * Copyright (c) 2000-2016 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQBLDCFG_H_
#define _TELCHEMY_VQBLDCFG_H_

#define VQMON_BUILDCFG_MEDIA    1

/*
 * VQmon package configuration options
 */
#if defined(VQMON_BUILDCFG_VOIP)
    #define VQMON_BUILDCFG_HAVEVOICE        1
    #define VQMON_BUILDCFG_NOMP2TS          1

#elif defined(VQMON_BUILDCFG_VIDCFR)
    #define VQMON_BUILDCFG_HAVEVOICE        1
    #define VQMON_BUILDCFG_NOMP2TS          1
    #define VQMON_BUILDCFG_HAVEVIDEO        1
    #define VQMON_BUILDCFG_HAVEAUDIO        1

#elif defined(VQMON_BUILDCFG_IPTV)
    #define VQMON_BUILDCFG_HAVEVIDEO        1
    #define VQMON_BUILDCFG_HAVEAUDIO        1

#elif defined(VQMON_BUILDCFG_MEDIA)
    #define VQMON_BUILDCFG_HAVEVOICE        1
    #define VQMON_BUILDCFG_HAVEVIDEO        1
    #define VQMON_BUILDCFG_HAVEAUDIO        1
    #define VQMON_BUILDCFG_HAVETCPSTRM      1

#elif defined(VQMON_BUILDCFG_COMBO)
    #define VQMON_BUILDCFG_HAVEVOICE        1
    #define VQMON_BUILDCFG_HAVEVIDEO        1
    #define VQMON_BUILDCFG_HAVEAUDIO        1

#elif defined(VQMON_BUILDCFG_IPTVTCP)
    #define VQMON_BUILDCFG_HAVEVIDEO        1
    #define VQMON_BUILDCFG_HAVEAUDIO        1
    #define VQMON_BUILDCFG_HAVETCPSTRM      1

#elif defined(VQMON_BUILDCFG_TCPSTRM)
    #define VQMON_BUILDCFG_HAVEVIDEO        1
    #define VQMON_BUILDCFG_HAVEAUDIO        1
    #define VQMON_BUILDCFG_HAVETCPSTRM      1
    #define VQMON_BUILDCFG_HAVETCPONLY      1

#elif defined(VQMON_BUILDCFG_DATA)
    #define VQMON_BUILDCFG_HAVEDATA         1
    #define VQMON_BUILDCFG_NOMP2TS          1

#elif defined(VQMON_BUILDCFG_TCPDATA)
    #define VQMON_BUILDCFG_HAVEVIDEO        1
    #define VQMON_BUILDCFG_HAVEAUDIO        1
    #define VQMON_BUILDCFG_HAVETCPSTRM      1
    #define VQMON_BUILDCFG_HAVEDATA         1
    #define VQMON_BUILDCFG_HAVETCPONLY      1

#elif defined(VQMON_BUILDCFG_VOIPTCP)
    #define VQMON_BUILDCFG_HAVEVOICE        1
    #define VQMON_BUILDCFG_HAVEVIDEO        1
    #define VQMON_BUILDCFG_HAVEAUDIO        1
    #define VQMON_BUILDCFG_HAVETCPSTRM      1
    #define VQMON_BUILDCFG_EXT_NOVIDCONF    1
    #define VQMON_BUILDCFG_EXT_NOIPTV       1
    
#elif defined(VQMON_BUILDCFG_VOIPDATA)
    #define VQMON_BUILDCFG_HAVEVOICE        1
    #define VQMON_BUILDCFG_HAVEDATA         1
    #define VQMON_BUILDCFG_NOMP2TS          1

#elif defined(VQMON_BUILDCFG_ALL)
    #define VQMON_BUILDCFG_HAVEVOICE        1
    #define VQMON_BUILDCFG_HAVEVIDEO        1
    #define VQMON_BUILDCFG_HAVEAUDIO        1
    #define VQMON_BUILDCFG_HAVETCPSTRM      1
    #define VQMON_BUILDCFG_HAVEDATA         1

#else
#error  VQmon packaging must be defined
#endif

/*
 * Multiple video layers support - as in H.264 SVC.
 */
#define VQMON_BUILDCFG_VIDEOLAYERS          1

#define VQMON_BUILDCFG_DETECT_ANOMALOUS_PKT 1

/*
 * Select the VMM version to use in monitoring.
 */
#define VQMON_BUILDCFG_USEVMMV1             1
#undef  VQMON_BUILDCFG_USEVMMV2
#undef  VQMON_BUILDCFG_USEVMMV3

#define VQMON_BUILDCFG_STREAM_RTPPTMAPSIZE  8
#define VQMON_BUILDCFG_IFACE_RTPPTMAPSIZE   32
#define VQMON_BUILDCFG_IFACE_PESTMAPSIZE    32

/*
 * Application protocol (HTTP, RTMP etc.) TCP port filter size.
 */
#define VQMON_BUILDCFG_IFACE_PROTOTCPPORTFILTERSIZE 16

/*
 * Maximum number of packets VQmon tries to analyze before notifying stream
 *  configuration errors.
 */
#define VQMON_BUILDCFG_STREAM_ANALYZEPKTCOUNT   100

#endif /* _TELCHEMY_VQBLDCFG_H_ */
