/* ###########################################################################
#
# Copyright (c) 2000-2015 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmonaud.h
 *
 * VQmon Public Header File - Audio-Specific Inclusions
 *
 * Copyright (c) 2000-2015 Telchemy, Incorporated
 */

#include "vqmon.h"
#include "vqmontyp.h"

#ifndef VQMON_BUILDCFG_NOMP2TS
#include "vqmonm2t.h"
#endif

#ifndef _TELCHEMY_VQMONAUD_H_
#define _TELCHEMY_VQMONAUD_H_

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Audio-Specific Constants
 *
 * --------------------------------------------------------------------------
 */

/*
 * Packet descriptor flags - video frame type information
 */
#define VQMON_AUDIO_FRAMETYPE_UNKNOWN               (0x00000000)
#define VQMON_AUDIO_FRAMEDESCVALID                  (0x00000001)
#define VQMON_AUDIO_FRAMESCRAMBLED                  (0x00000020)
#define VQMON_AUDIO_TRANSPORTSCRAMBLED              (0x00000040)
#define VQMON_AUDIO_PTSVALID                        (0x00400000)


/*
 * Mask for audio.
 */
#define VQMON_MEDIATYPEMASK_AUDIO                   (0x1000)


/*
 * Interface-specific audio operation codes.
 */
#define VQMON_IFMETRICBLOCKID_AUDIOSTATS            (0x1321)

/*
 * Stream audio default configuration.
 */
#define VQMON_STREAMCFGBLOCKID_AUDIOGENCFGDEF       (0x1101)
#define VQMON_STREAMCFGBLOCKID_AUDIOTHRESHDEF       (0x1102)
#define VQMON_STREAMCFGBLOCKID_AUDIOPLAYOUTBUFDEF   (0x1103)

/*
 * Stream audio configuration and metric block codes.
 */
#define VQMON_STREAMCFGBLOCKID_AUDIOGENCFG          (0x1201)
#define VQMON_STREAMCFGBLOCKID_AUDIOTHRESH          (0x1202)

#define VQMON_STREAMMETRICBLOCKID_AUDIODESC         (0x1301)
#define VQMON_STREAMMETRICBLOCKID_AUDIOQUAL         (0x1302)
#define VQMON_STREAMMETRICBLOCKID_AUDIOBW           (0x1303)

#define VQMON_STREAMMETRICBLOCKID_AUDIOINTERVAL     (0x1310)

/*
 * VQmon audio stream interval metrics validity flags.
 */
#define VQMON_STREAMMETRICVALID_AUDIOINTVL_PPDV         (0x0001)
#define VQMON_STREAMMETRICVALID_AUDIOINTVL_PCRJITTER    (0x0002)


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Audio-Specific Enumerations
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon audio CODEC identifiers.
 */
typedef enum
{
    vqmonCODECAudioUnknown          = 0,
    vqmonCODECAudioMPEGL1           = 0x1001,
    vqmonCODECAudioMPEGL2           = 0x1002,
    vqmonCODECAudioMPEGL3           = 0x1003,
    vqmonCODECAudioMPEG2AAC         = 0x1004,
    vqmonCODECAudioAC3              = 0x1005,
    vqmonCODECAudioMPEG4AAC         = 0x1006,
    vqmonCODECAudioMPEG4LDAAC       = 0x1007,
    vqmonCODECAudioMPEG4HEAAC       = 0x1008,
    vqmonCODECAudioWMAP             = 0x1009,
    vqmonCODECAudioMPEG4HEAACv2     = 0x100a,
    vqmonCODECAudioMPEG4LCAAC       = 0x100b,
    vqmonCODECAudioAMRWBPlus        = 0x100c,
    vqmonCODECAudioVorbis           = 0x100d,
    vqmonCODECAudioMax,

    vqmonCODECAudioSDPPktLoopback   = 0x1FF2,
 
    vqmonCODECAudioUser1            = 0x1FFC,
    vqmonCODECAudioUser2            = 0x1FFD,
    vqmonCODECAudioUser3            = 0x1FFE,
    vqmonCODECAudioUser4            = 0x1FFF,

} vqmon_codecaudio_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Audio-Specific Complex Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * Interface audio statistics.
 */
struct _vqmon_interfacestats_audiostrm_s
{
    tcmyU32                     nStreamsActive;
    tcmyU32                     nStreamsTerminated;

    tcmyU64                     nPktsRcvd;
    tcmyU64                     nPktsLost;
    tcmyU64                     nPktsDiscarded;

    vqmon_mos_t                 nMinMOS_A;
    vqmon_mos_t                 nAvgMOS_A;
    vqmon_mos_t                 nMaxMOS_A;
};

typedef struct _vqmon_interfacestats_audiostrm_s \
    vqmon_interfacestats_audiostrm_t;


/*
 * VQmon stream audio general configuration.
 */
struct _vqmon_streamcfg_audiogencfg_s
{
    tcmyU32                     fStreamDescFlags;

    tcmyU8                      nChannels;

    tcmyU32                     nRefClockRateHz;
};

typedef struct _vqmon_streamcfg_audiogencfg_s \
    vqmon_streamcfg_audiogencfg_t;


/*
 * VQmon stream audio perceptual quality thresholds.
 */
struct _vqmon_streamcfg_audiothold_s
{
    vqmon_mos_t                 nThresholdMOS_A;
};

typedef struct _vqmon_streamcfg_audiothold_s \
    vqmon_streamcfg_audiothold_t;


/*
 * VQmon stream audio description information block.
 */
struct _vqmon_streammetrics_audiodesc_s
{
    vqmon_streamcfg_netepdesc_t tEndpointDesc;
    tcmyU32                     fStreamDescFlags;

    vqmon_codecid_t             idCODECType;
    tcmyS8                      nChannels;

    tcmyU32                     nRefClockRateHz;
};

typedef struct _vqmon_streammetrics_audiodesc_s \
    vqmon_streammetrics_audiodesc_t;


/*
 * VQmon stream audio perceptual quality metrics block.
 */
struct _vqmon_streammetrics_audioqual_s
{
    vqmon_mos_t                 nMinMOS_A;
    vqmon_mos_t                 nAvgMOS_A;
    vqmon_mos_t                 nMaxMOS_A;
    vqmon_mos_t                 nInstMOS_A;
    vqmon_proportion_t          nPropBelowTholdMOS_A;

    struct 
    {
        vqmon_degsevlvl_t       nLossDeg;
        vqmon_degsevlvl_t       nDiscardDeg;
        vqmon_degsevlvl_t       nCODECDeg;
        vqmon_degsevlvl_t       nRecencyDeg;

    } deg_factors;
};

typedef struct _vqmon_streammetrics_audioqual_s \
    vqmon_streammetrics_audioqual_t;


/* 
 * VQmon stream audio bandwidth metrics block.
 */
struct _vqmon_streammetrics_audiobw_s
{
    tcmyU32                     nAvgAudioBandwidth;
    tcmyU32                     nPeakAudioBandwidth;
    tcmyU32                     nAvgRcvBandwidth;
    tcmyU32                     nPeakRcvBandwidth;
};

typedef struct _vqmon_streammetrics_audiobw_s \
    vqmon_streammetrics_audiobw_t;


/*
 * VQmon stream audio interval metrics block.
 */
struct _vqmon_streammetrics_audiointerval_s
{
    vqmon_time_t                tStartTime;
    vqmon_time_t                tEndTime;

    tcmyU32                     nPktsRcvd;
    tcmyU32                     nPktsLost;
    tcmyU32                     nPktsDiscarded;
    tcmyU32                     nPktsOutOfSequence;
    tcmyU32                     nPktsDuplicated;
    tcmyU32                     nPktsCorrected;
    vqmon_proportion_t          nAvgEffPktLossRate;

    tcmyU16                     nBurstCount;
    vqmon_proportion_t          nBurstLossRate;
    tcmyU32                     nBurstLengthPkts;
    tcmyU16                     nGapCount;
    vqmon_proportion_t          nGapLossRate;
    tcmyU32                     nGapLengthPkts;

    vqmon_ufpq4_t               nPPDVMs;
    vqmon_ufpq4_t               nPCRJitterMs;
    tcmyU32                     fIntervalMetrics;

    vqmon_mos_t                 nMOS_A;
    vqmon_mos_t                 nMinMOS_A;
    vqmon_mos_t                 nMaxMOS_A;
    vqmon_mos_t                 nInstMOS_A;

    tcmyU32                     nAvgAudioBandwidth;
    tcmyU32                     nAvgRcvBandwidth;
};

typedef struct _vqmon_streammetrics_audiointerval_s \
    vqmon_streammetrics_audiointerval_t;


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONAUD_H_ */
