/* ###########################################################################
#
# Copyright (c) 2000-2016 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmoncmp.h
 *
 * VQmon Public Header File - Definitions to Maintain Backwards Compatibility
 *
 * Copyright (c) 2000-2016 Telchemy, Incorporated
 */

#include "vqmoncfg.h"

#ifndef _TELCHEMY_VQMONCMP_H_
#define _TELCHEMY_VQMONCMP_H_

#ifdef VQMON_BUILDCFG_HAVEVIDEO

/* vqmonvid.h */
/* vqmonsvd.h */
#define nMinMOS_V                   nMinAbsoluteMOS_V
#define nAvgMOS_V                   nAvgAbsoluteMOS_V
#define nMaxMOS_V                   nMaxAbsoluteMOS_V

#define nMOS_AV                     nAbsoluteMOS_AV
#define nMinMOS_AV                  nMinAbsoluteMOS_AV
#define nAvgMOS_AV                  nAvgAbsoluteMOS_AV
#define nMaxMOS_AV                  nMaxAbsoluteMOS_AV
#define nInstMOS_AV                 nInstAbsoluteMOS_AV

#define nThresholdMOS_AV            nThresholdAbsoluteMOS_AV
#define nPropBelowTholdMOS_AV       nPropBelowTholdAbsMOS_AV

#endif  /* VQMON_BUILDCFG_HAVEVIDEO */

#ifdef VQMON_BUILDCFG_HAVEVOICE

/* vqmonvce.h */

#define VQMON_STREAMCFGBLOCKID_VOICERTCPXRDEF   \
    VQMON_STREAMCFGBLOCKID_VOICERTCPPKTUSAGEDEF
#define VQMON_STREAMCFGBLOCKID_VOICERTCPXR      \
    VQMON_STREAMCFGBLOCKID_VOICERTCPPKTUSAGE

#define vqmonCODECVoiceEVRCFR       vqmonCODECVoiceEVRC
#define vqmonCODECVoiceEVRCHR       vqmonCODECVoiceEVRC
#define vqmonCODECVoiceEVRCER       vqmonCODECVoiceEVRC
#define vqmonCODECVoiceEVRCQR       vqmonCODECVoiceEVRC

#define vqmonCODECVoiceEVRCMODE0    vqmonCODECVoiceEVRC
#define vqmonCODECVoiceEVRCMODE1    vqmonCODECVoiceEVRC
#define vqmonCODECVoiceEVRCMODE2    vqmonCODECVoiceEVRC

#define vqmonCODECVoiceEVRCBMODE0   vqmonCODECVoiceEVRCB
#define vqmonCODECVoiceEVRCBMODE1   vqmonCODECVoiceEVRCB
#define vqmonCODECVoiceEVRCBMODE2   vqmonCODECVoiceEVRCB

#define vqmonCODECVoiceSMVMODE0     vqmonCODECVoiceSMV
#define vqmonCODECVoiceSMVMODE1     vqmonCODECVoiceSMV
#define vqmonCODECVoiceSMVMODE2     vqmonCODECVoiceSMV
#define vqmonCODECVoiceSMVMODE3     vqmonCODECVoiceSMV

#endif /* VQMON_BUILDCFG_HAVEVOICE */

/* vqmonstm.h */
#define nUncorrectedLossProp        nNetworkLossProp
#define VQMON_STREAMRPTTYPE_RTCPXR                  (0x4001)
#define VQMON_STREAMRPTTYPE_RTCPHR                  (0x4002)
#define VQMON_STREAMRPTTYPE_SIPRTCPSUM              (0x4003)
#define vqmonStreamReportTypeSIPVQSession   \
    vqmonStreamReportTypeSIPRTCPSummary

#define VQMON_STREAMTYPE_AUDIOVISUAL    VQMON_STREAMTYPE_STRMSESSION
#define vqmonStreamTypeAudioVisual      vqmonStreamTypeStrmSession


#endif  /* _TELCHEMY_VQMONCMP_H_ */
