/* ###########################################################################
#
# Copyright (c) 2000-2016 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmonif.h
 *
 * VQmon Public Header File - Logical Interfaces
 *
 * Copyright (c) 2000-2016 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQMONIF_H_
#define _TELCHEMY_VQMONIF_H_

#include "vqmon.h"
#include "vqmontyp.h"
#if (defined(VQMON_BUILDCFG_HAVEVOICE) || defined(VQMON_BUILDCFG_HAVEVIDEO))
#include "vqmonstm.h"
#endif
#ifndef  VQMON_BUILDCFG_NOMP2TS
#include "vqmonm2t.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* --------------------------------------------------------------------------
 *
 *      VQmon Public Logical Interface Constant Definitions
 *
 * --------------------------------------------------------------------------
 */

/*
 * Default logical interface definition.
 */
#define VQMON_DEFAULT_LOGICALINTERFACE              (NULL)

/*
 * Logical interface statistics/metrics block identifiers.
 */
#define VQMON_IFMETRICBLOCKID_GENERAL               (0x0321)
#define VQMON_IFMETRICBLOCKID_PACKETSTATS           (0x0322)
#define VQMON_IFMETRICBLOCKID_JITTERDELAYSTATS      (0x0323)

#define VQMON_IFMETRICBLOCKID_STREAMTABLESTATS      (0x0351)
#define VQMON_IFMETRICBLOCKID_SRCDSTTABLESTATS      (0x0352)
#define VQMON_IFMETRICBLOCKID_STREAMTBLLOOKUPSTATS  (0x0355)
#define VQMON_IFMETRICBLOCKID_SRCDSTTBLLOOKUPSTATS  (0x0356)

/*
 * Logical interface data metrics block identifiers (interval based).
 */
#define VQMON_IFDATAMETRICBLKID_ACTIVEPIPES         (0x0380)

/*
 * Logical interface statistics/metrics validity flags.
 */
#define VQMON_IFMETRICVALID_JITTERDLY_MAPDV         (0x0001)
#define VQMON_IFMETRICVALID_JITTERDLY_PPDV          (0x0002)
#define VQMON_IFMETRICVALID_JITTERDLY_PCRJITTER     (0x0004)
#define VQMON_IFMETRICVALID_JITTERDLY_RTDELAY       (0x0010)
#define VQMON_IFMETRICVALID_JITTERDLY_OWDELAY       (0x0020)

/*
 * Logical interface protocol support mode flags.
 */
#define VQMON_IFPROTOMODE_IUUP_AUTO                 (0x0000)
#define VQMON_IFPROTOMODE_IUUP_FORCED               (0x0001)
#define VQMON_IFPROTOMODE_IUUP_DISABLED             (0x0002)
#define VQMON_IFPROTOMODE_RTP_MERGEONSSRCCHG        (0x0010)
#define VQMON_IFPROTOMODE_RTP_NOSIBLINGLOOKUP       (0x0020)
#define VQMON_IFPROTOMODE_VOICE_SIBLINGLOOKUP       (0x0040)

/*
 * Default stream packet buffer size in packets for out-of-order TCP packets.
 */
#define VQMON_IFSTREAM_TCPPKTBUFFSIZE_DEF           (128)


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Logical Interface Enumerations
 *
 * --------------------------------------------------------------------------
 */

/*
 * Logical interface event types.
 */
typedef enum
{
    vqmonInterfaceEventUnknown      = 0x00,
    vqmonInterfaceEventUp           = 0x01,
    vqmonInterfaceEventDown         = 0x02,
    vqmonInterfaceEventIntervalEnd  = 0x03,
    vqmonInterfaceEventDataItvlEnd  = 0x04

} vqmon_interfaceevt_t;


/*
 * Logical interface state.
 */
typedef enum
{
    vqmonInterfaceStateUnknown      = 0x00,
    vqmonInterfaceStateUp           = 0x01,
    vqmonInterfaceStateDown         = 0x02

} vqmon_interfacestate_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Logical Interface Simple Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon interface statistics block identifier.
 */
typedef tcmyU16 vqmon_ifstatblkid_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Logical Interface Complex Data Structures
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon logical interface properties.
 */

struct _vqmon_interfaceprops_s
{
    tcmyCHAR                    strDesc[VQMON_MAXSTRLENGTH];

    vqmon_interfacestate_t      eIfState;
    tcmyU32                     nIfRcvBitrate;

    tcmyU16                     nStreamValidationPkts;
    void*                       pAppData;

    tcmyU16                     nStreamCODECDelayPkts;
    tcmyU16                     nStreamTcpPktBuffSize;
    tcmyU32                     fIfProtoMode;

    tcmyS32                     nStreamDemuxBins;

#ifdef VQMON_BUILDCFG_HAVEDATA
    tcmyS32                     nDataPipeDemuxBins;
    tcmyU32                     nDataMaxPipes;

    tcmyS32                     nDataSessionDemuxBins;
    tcmyU32                     nDataMaxSessions;

    tcmyS32                     nDataSessionPortPairsDemuxBins;
    tcmyU32                     nDataMaxSessionPortPairs;
#endif
};

typedef struct _vqmon_interfaceprops_s vqmon_interfaceprops_t;


/*
 * VQmon logical interface general statistics block.
 */
struct _vqmon_interfacestats_general_s
{
    tcmyU32                     streamsActive;
    tcmyU32                     streamsTerminated;
};

typedef struct _vqmon_interfacestats_general_s vqmon_interfacestats_general_t;

#if (defined(VQMON_BUILDCFG_HAVEVOICE) || defined(VQMON_BUILDCFG_HAVEVIDEO))
/*
 * VQmon interface packet statistics block.
 */
struct _vqmon_interfacestats_pkt_s
{
    tcmyU64                     nPktsRcvd;
    tcmyU64                     nPktsLost;
    tcmyU64                     nPktsDiscarded;

    tcmyU32                     nMinPktsLost;
    tcmyU32                     nAvgPktsLost;
    tcmyU32                     nMaxPktsLost;

    tcmyU32                     nMinPktsDiscarded;
    tcmyU32                     nAvgPktsDiscarded;
    tcmyU32                     nMaxPktsDiscarded;
};

typedef struct _vqmon_interfacestats_pkt_s vqmon_interfacestats_pkt_t;


/*
 * VQmon interface jitter/delay statistics block.
 */
struct _vqmon_interfacestats_jitterdly_s
{
    vqmon_ufpq4_t               nAvgMAPDVMs;
    vqmon_ufpq4_t               nMaxMAPDVMs;
    vqmon_ufpq4_t               nAvgPPDVMs;
    vqmon_ufpq4_t               nMaxPPDVMs;
    vqmon_ufpq4_t               nAvgPCRJitterMs;
    vqmon_ufpq4_t               nMaxPCRJitterMs;

    tcmyU16                     nAvgRTDelayMs;
    tcmyU16                     nMaxRTDelayMs;
    tcmyU32                     nAvgOWDelayMs;
    tcmyU32                     nMaxOWDelayMs;
    tcmyU32                     fJitterDlyMetrics;
};

typedef struct _vqmon_interfacestats_jitterdly_s \
    vqmon_interfacestats_jitterdly_t;


/*
 * VQmon interface stream list item descriptor.
 */
struct _vqmon_interfacestreamdesc_s
{
    vqmon_ipaddr_t              tSrcAddress;
    vqmon_ipaddr_t              tDstAddress;
    tcmyU16                     nSrcPort;
    tcmyU16                     nDstPort;
    tcmyU16                     nVlanTag;
    tcmyU16                     nServiceVlanTag;
    vqmon_streamtransproto_t    eTransProtos;
    tcmyU32                     nTransProtoSrcId;

#ifndef VQMON_BUILDCFG_NOMP2TS
    vqmon_streamproginfo_key_t  tKey;
#endif
};

typedef struct _vqmon_interfacestreamdesc_s vqmon_interfacestreamdesc_t;


/*
 * VQmon interface (stream/srcdst) hash table general statistics.
 */
struct _vqmon_interfaces_htblgenstats_s
{
    tcmyU32                     nDemuxBins;
    tcmyU32                     nNodeCount;
    tcmyU32                     nOccupiedBins;
    tcmyU32                     nMaxBinLength;
};

typedef struct _vqmon_interfaces_htblgenstats_s \
    vqmon_interfaces_htblgenstats_t;

/*
 * VQmon interface (stream/srcdst) hash table node lookup statistics.
 */
struct _vqmon_interfaces_htbllookupstats_s
{
    tcmyU32                     nNodesSearched;
    tcmyU32                     nNodesFound;
    tcmyU32                     nNodesTraversed;
    tcmyU32                     nHashValueHit;
};

typedef struct _vqmon_interfaces_htbllookupstats_s \
    vqmon_interfaces_htbllookupstats_t;
#endif

/*
 * VQmon interface data metrics - (active) pipes block in previous interval.
 */
struct _vqmon_interface_datapipes_s
{
    tcmyU32                     nNumPipes;
    vqmon_handle_t              ahPipes[1];
};

typedef struct _vqmon_interface_datapipes_s vqmon_interface_datapipes_t;


/*
 * VQmon stream descriptor flags
 */
#define VQMON_STREAMDESC_VLANTAG_VALID          (0x0002)
#define VQMON_STREAMDESC_SERVICEVLANTAG_VALID   (0x0004)
#ifdef VQMON_BUILDCFG_FLOWHASH
#define VQMON_STREAMDESC_ADDITIONALTAG_VALID    (0x0008)
#endif
#define VQMON_STREAMDESC_SSRC_VALID             (0x0020)
#define VQMON_STREAMDESC_PID_VALID              (0x0040)

/*
 * VQmon stream descriptor structure.
 */
struct _vqmon_streamdesc_s
{
    vqmon_ipaddr_t                  tSrcAddress;
    vqmon_ipaddr_t                  tDstAddress;
    tcmyU16                         nSrcPort;
    tcmyU16                         nDstPort;
    tcmyU32                         nSSRC;
    tcmyU16                         nPid;
    tcmyU16                         fDescFlags;
    tcmyU16                         aVLANTags[VQMON_MAX_VLAN_TAGS];
#ifdef VQMON_BUILDCFG_FLOWHASH
    tcmyU64                         nReserved;
#endif
};

typedef struct _vqmon_streamdesc_s vqmon_streamdesc_t;



/* --------------------------------------------------------------------------
 *
 *      VQmon Public Logical Interface Functions
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon logical interface methods.
 */
VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceCreate(
    vqmon_handle_t* const phInterface,
    const vqmon_interfaceprops_t* pProperties
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceDestroy(
    vqmon_handle_t hInterface
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceConfigGet(
    const vqmon_handle_t hInterface,
    vqmon_interfaceprops_t* const pProperties
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceConfigSet(
    vqmon_handle_t const hInterface,
    const vqmon_interfaceprops_t* pProperties
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceIndicatePacket(
    vqmon_handle_t const hInterface,
    const vqmon_time_t tRcvTimestamp,
    vqmon_pktdesc_t* pPktDesc
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceIndicateEvent(
    vqmon_handle_t const hInterface,
    const vqmon_interfaceevt_t eEventType,
    const vqmon_time_t tEventTime
    );

#if (defined(VQMON_BUILDCFG_HAVEVOICE) || defined(VQMON_BUILDCFG_HAVEVIDEO))
VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStatisticsGet(
    vqmon_handle_t const hInterface,
    const vqmon_ifstatblkid_t idIfStatBlock,
    tcmyU32* const pnStatBlockSz,
    void* const pStatBlock
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStatisticsClear( 
    vqmon_handle_t const hInterface,
    const vqmon_ifstatblkid_t idIfStatBlock
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStreamsEnumerate(
    const vqmon_handle_t hInterface,
    tcmyU32* const pnNumStreamDescriptors,
    vqmon_interfacestreamdesc_t* const pIfStreamDescList
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStreamsCleanupInactive(
    vqmon_handle_t const hInterface,
    const vqmon_time_t tCurTime,
    const tcmyU16 nInactiveSecs
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStreamsCleanupInactiveEx(
    vqmon_handle_t const hInterface,
    const vqmon_time_t tCurTime,
    const tcmyU16 nInactiveSecs,
    const tcmyU16 nSpecialInactiveSecs,
    tcmyS32* const pNumNodes
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStreamsCleanupInactiveEx2(
    vqmon_handle_t const hInterface,
    const vqmon_time_t tCurTime,
    const tcmyU16 nInactiveSecs,
    const tcmyU16 nSpecialInactiveSecs,
    const tcmyU16 nStrmSessTransInactiveSecs,
    tcmyS32* const pNumNodes
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStreamsDefaultCfgGet(
    const vqmon_handle_t hInterface,
    vqmon_streamtype_t eStreamType,
    const tcmyU32 idConfigBlock,
    tcmyU32* const pnConfigBufSz,
    void* const pConfigBuf
);

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStreamsDefaultCfgSet(
    const vqmon_handle_t hInterface,
    vqmon_streamtype_t eStreamType,
    const tcmyU32 idConfigBlock,
    const tcmyU32 nConfigBufSz,
    const void* pConfigBuf
);

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStreamMetricsGet(
    const vqmon_handle_t hInterface,
    const vqmon_interfacestreamdesc_t* pStreamDesc,
    const vqmon_streammetricblkid_t idMetricsBlock,
    tcmyU32* const pnMetricsBufSz,
    void* const pMetricsBuf
    );
#endif

#ifndef VQMON_BUILDCFG_NOMP2TS
VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStreamProgramInfoTableGet(
    const vqmon_handle_t hInterface,
    const vqmon_streamproginfo_key_t* pKey,
    const vqmon_streamproginfotabletype_t eProgInfoTableType,
    tcmyU32* const pnNumProgInfoTableEntries,
    vqmon_streamproginfo_tableentry_t* const pProgInfoTable
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceStreamProgramInfoTableEntryDescGet(
    const vqmon_handle_t hInterface,
    const vqmon_streamproginfo_key_t* pKey,
    const vqmon_streamproginfodesctype_t eProgInfoTableDesc,
    tcmyU32* const pnNumProgInfoTableDescEntries,
    vqmon_streamproginfo_tableentrydesc_t* const pProgInfoTableEntryDesc
    );
#endif

#if (defined(VQMON_BUILDCFG_HAVEVOICE) || defined(VQMON_BUILDCFG_HAVEVIDEO))
VQMON_PUBLIC(vqmon_handle_t)
VQmonInterfaceStreamHandleGet(
    vqmon_handle_t const hInterface,
    const vqmon_streamdesc_t* pStreamDesc
    );
#endif

/*
 * VQmon logical interface methods for data interval metrics.
 */
#ifdef VQMON_BUILDCFG_HAVEDATA
VQMON_PUBLIC(vqmon_result_t)
VQmonInterfacePipeDefaultCfgGet(
    const vqmon_handle_t hInterface,
    const tcmyU16 idConfigBlock,
    tcmyU32* const pnConfigBufSz,
    void* const pConfigBuf
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfacePipeDefaultCfgSet(
    const vqmon_handle_t hInterface,
    const tcmyU16 idConfigBlock,
    const tcmyU32 nConfigBufSz,
    const void* pConfigBuf
    );

VQMON_PUBLIC(vqmon_result_t)
VQmonInterfaceDataIntervalMetricsGet(
    vqmon_handle_t const hInterface,
    const tcmyU16 idDataMetricsBlock,
    tcmyU32* const pnMetricsBlockSz,
    void* const pMetricsBlock
    );
#endif

#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONIF_H_ */
