/* ###########################################################################
#
# Copyright (c) 2000-2015 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* vqmonrpt.h
 *
 * VQmon Public Report Generation Interface Definitions
 *
 * Copyright (c) 2000-2015 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQMONRPT_H_
#define _TELCHEMY_VQMONRPT_H_

#include "vqmon.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * VQmon SIP report information block validity flags.
 */
typedef enum
{
    vqmonSIPSessionInfoCallId           = 0x0001,
    vqmonSIPSessionInfoLocalId          = 0x0002,
    vqmonSIPSessionInfoRemoteId         = 0x0004,
    vqmonSIPSessionInfoOrigId           = 0x0008,
    vqmonSIPSessionInfoLocalGroupId     = 0x0010,
    vqmonSIPSessionInfoRemoteGroupId    = 0x0020,
    vqmonSIPSessionInfoRemoteSSRC       = 0x0040

} vqmon_sipreportinfoflag_t;

/*
 * VQmon SIP report information block.
 */
struct _vqmon_sipreportinfo_s
{
    tcmyU32             fSIPReportInfoFlags;

    tcmyCHAR            strCallID[VQMON_MAXSTRLENGTH];

    tcmyCHAR            strLocalID[VQMON_MAXSTRLENGTH];
    tcmyCHAR            strRemoteID[VQMON_MAXSTRLENGTH];
    tcmyCHAR            strOrigID[VQMON_MAXSTRLENGTH];

    tcmyCHAR            strLocalGroupID[VQMON_MAXSTRLENGTH];
    tcmyCHAR            strRemoteGroupID[VQMON_MAXSTRLENGTH];

    tcmyU32             nRemoteSSRC;

};

typedef struct _vqmon_sipreportinfo_s vqmon_sipreportinfo_t;


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONRPT_H_ */
