/* ###########################################################################
#
# Copyright (c) 2000-2015 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmontyp.h
 *
 * VQmon Public Type Definition Header File
 *
 * Copyright (c) 2000-2015 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQMONTYP_H_
#define _TELCHEMY_VQMONTYP_H_

#ifndef _TELCHEMY_VQMONDEF_H_
#include "vqmondef.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Common Simple Data Types
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon generic object handle.
 */
typedef void*                       vqmon_handle_t;

/*
 * VQmon result.
 *   The signed result value used to indicate possible errors.
 */
typedef tcmyS16                     vqmon_result_t;

/*
 * VQmon size.
 */
typedef size_t                      vqmon_size_t;

/*
 * VQmon fixed-point values (signed Q4 and Q8 respectively).
 */
typedef tcmyS16                     vqmon_fpq4_t;
typedef tcmyU16                     vqmon_ufpq4_t;
typedef tcmyS16                     vqmon_fpq8_t;
typedef tcmyU16                     vqmon_ufpq8_t;

/*
 * VQmon proportion - fixed point where the radix point is to the left
 *    of the most significant bit.
 */
typedef tcmyU32                     vqmon_proportion_t;

/* 
 * VQmon percentage - fixed point where the radix point is between bit
 *    8 and 9 (Q8) of the field.
 */
typedef tcmyS16                     vqmon_percent_t;

/*
 * VQmon time.
 */
typedef struct timeval              vqmon_time_t;

/* 
 * VQmon R-factor - fixed point where the radix point is between bit
 *    8 and 9 (Q8) of the field.
 */
typedef tcmyU16                     vqmon_rfactor_t;

/*
 * VQmon MOS - fixed point where the radix point is between bit 8 and 9
 *   (Q8) of the field. Thus, all output incorporating a vqmon_mos_t score
 *   must include a division by 256.
 */
typedef tcmyU16                     vqmon_mos_t;

/*
 * VQmon degradation severity - a scalar value between 0 and 10 where 0 
 *   indicates no degradation and 10 indicates severe degradation.
 */
typedef tcmyU8                      vqmon_degsevlvl_t;


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONTYP_H_ */
