/* ###########################################################################
#
# Copyright (c) 2000-2016 Telchemy, Incorporated. All Rights Reserved.
#
# Telchemy Confidential and Proprietary
#
# The following software source code ("Software") is strictly confidential
# and is proprietary to Telchemy, Incorporated ("Telchemy").  It may only
# be read, used, copied, adapted, modified or otherwise utilized by parties
# (individuals, corporations, or organizations) that have entered into a
# license agreement or confidentiality agreement with Telchemy, and are thus
# subject to the terms of that license agreement or confidentiality agreement
# and any other applicable agreement between the party and Telchemy.  If
# there is any doubt as to whether a party is entitled to access, read, use,
# copy, adapt, modify or otherwise utilize the Software, or whether a party
# is entitled to disclose the Software to any other party, you should contact
# Telchemy.  If you, as a party, have not entered into a license agreement or
# confidentiality agreement with Telchemy granting access to this Software,
# all media, copies and printed listings containing the Software should be
# forthwith returned to Telchemy.
#
# This Software is protected by Granted and Pending Patents owned by Telchemy,
# Incorporated.
#
# Telchemy reserves the right to take legal action against any party that
# violates Telchemy's rights to the Software, including without limitation a
# party's breach of the above conditions.
#
# If you have questions about any of the above conditions, or wish to report
# violations, please contact:  support@telchemy.com
#
# ##########################################################################*/

/* 
 * vqmonvce.h
 *
 * VQmon Public Header File - Voice-Specific Inclusions
 *
 * Copyright (c) 2000-2016 Telchemy, Incorporated
 */

#ifndef _TELCHEMY_VQMONVCE_H_
#define _TELCHEMY_VQMONVCE_H_

#include "vqmon.h"

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Voice-Specific Constants
 *
 * --------------------------------------------------------------------------
 */

/*
 * Stream voice configuration and metric block codes.
 */

#define VQMON_STREAMCFGBLOCKID_VOICEGENCFGDEF       (0x4101)
#define VQMON_STREAMCFGBLOCKID_VOICEANALOGDEF       (0x4102)
#define VQMON_STREAMCFGBLOCKID_VOICERTCPPKTUSAGEDEF (0x4103)
#define VQMON_STREAMCFGBLOCKID_VOICEJITTERBUFFERDEF (0x4104)
#define VQMON_STREAMCFGBLOCKID_VOICEESDELAYDEF      (0x4105)
#define VQMON_STREAMCFGBLOCKID_ROUNDTRIPDELAYDEF    (0x4106)
#define VQMON_STREAMCFGBLOCKID_VOICERTPPKTDURDEF    (0x4107)
#define VQMON_STREAMCFGBLOCKID_VOICEG107DEF         (0x4108)
#define VQMON_STREAMCFGBLOCKID_VOICECODECPREFDEF    (0x4109)

#define VQMON_STREAMCFGBLOCKID_VOICEGENCFG          (0x4201)
#define VQMON_STREAMCFGBLOCKID_VOICEANALOG          (0x4202)
#define VQMON_STREAMCFGBLOCKID_VOICERTCPPKTUSAGE    (0x4203)
#define VQMON_STREAMCFGBLOCKID_VOICEJITTERBUFFER    (0x4204)
#define VQMON_STREAMCFGBLOCKID_VOICEESDELAY         (0x4205)
#define VQMON_STREAMCFGBLOCKID_VOICERTPPKTDUR       (0x4206)
#define VQMON_STREAMCFGBLOCKID_VOICEG107            (0x4207)

#define VQMON_STREAMMETRICBLOCKID_VOICEJITTER       (0x4301)
#define VQMON_STREAMMETRICBLOCKID_VOICEQUAL         (0x4302)
#define VQMON_STREAMMETRICBLOCKID_VOICEINTERVAL     (0x4303)
#define VQMON_STREAMMETRICBLOCKID_VOICEANALOG       (0x4304)
#define VQMON_STREAMMETRICBLOCKID_VOICEESDELAY      (0x4305)
#define VQMON_STREAMMETRICBLOCKID_VOICEXR           (0x4306)
#define VQMON_STREAMMETRICBLOCKID_VOICEDATAMETRICS  (0x4307)
#define VQMON_STREAMMETRICBLOCKID_VOICELASTRTCPXR   (0x4308)
#define VQMON_STREAMMETRICBLOCKID_VOICERTCPQUAL     (0x4309)

/*
 * Interface-specific voice operation codes.
 */
#define VQMON_IFMETRICBLOCKID_VOICESTATS            (0xC321)

/* --------------------------------------------------------------------------
 *
 *      VQmon Public Voice-Specific Enumerations
 *
 * --------------------------------------------------------------------------
 */

/*
 * VQmon voice CODEC identifiers.
 */
typedef enum
{
    vqmonCODECVoiceUnknown          = 0,
    vqmonCODECVoiceG711u            = 0x4001,
    vqmonCODECVoiceG711uPLC         = 0x4002,
    vqmonCODECVoiceG723153K         = 0x4003,
    vqmonCODECVoiceG723163K         = 0x4004,
    vqmonCODECVoiceG728             = 0x4005,
    vqmonCODECVoiceG729             = 0x4006,
    vqmonCODECVoiceG729A            = 0x4007,
    vqmonCODECVoiceGSMFR            = 0x4008,
    vqmonCODECVoiceGSMHR            = 0x4009,
    vqmonCODECVoiceGSMEFR           = 0x400A,
    vqmonCODECVoiceSX7300           = 0x400B,
    vqmonCODECVoiceSX9600           = 0x400C,
    vqmonCODECVoiceG711A            = 0x400D,
    vqmonCODECVoiceG711APLC         = 0x400E,
    vqmonCODECVoiceG72616K          = 0x400F,
    vqmonCODECVoiceG72624K          = 0x4010,
    vqmonCODECVoiceG72632K          = 0x4011,
    vqmonCODECVoiceG72640K          = 0x4012,
    vqmonCODECVoiceGIPSE711u        = 0x4013,
    vqmonCODECVoiceGIPSE711A        = 0x4014,
    vqmonCODECVoiceGIPSiLBC         = 0x4015,
    vqmonCODECVoiceGIPSiSAC         = 0x4016,
    vqmonCODECVoiceGIPSiPCMwb       = 0x4017,
    vqmonCODECVoiceG729E8k0         = 0x4018,
    vqmonCODECVoiceG729E11k8        = 0x4019,

    vqmonCODECVoiceWBLinearPCM      = 0x401A, /* deprecated */
    vqmonCODECVoiceWBLinearPCM_PLC  = 0x401B, /* deprecated */

    /*
     * Siren7
     */
    vqmonCODECVoiceG7221_32k        = 0x401F,
    vqmonCODECVoiceG7221_24k        = 0x4020,
    
    vqmonCODECVoiceG7222_23k85      = 0x4021,
    vqmonCODECVoiceG7222_23k05      = 0x4022,
    vqmonCODECVoiceG7222_19k85      = 0x4023,
    vqmonCODECVoiceG7222_18k25      = 0x4024,
    vqmonCODECVoiceG7222_15k85      = 0x4025,
    vqmonCODECVoiceG7222_14k25      = 0x4026,
    vqmonCODECVoiceG7222_12k65      = 0x4027,
    vqmonCODECVoiceG7222_8k85       = 0x4028,
    vqmonCODECVoiceG7222_6k6        = 0x4029,
    vqmonCODECVoiceQCELP8           = 0x402A,
    vqmonCODECVoiceQCELP13          = 0x402B,
    vqmonCODECVoiceEVRC             = 0x402C,
    
    vqmonCODECVoiceSMV              = 0x4034, /* 0x402C+8 */
    
    vqmonCODECVoiceAMRNB12k2        = 0x403C, /* 0x4034+8 */
    vqmonCODECVoiceAMRNB10k2        = 0x403D,
    vqmonCODECVoiceAMRNB7k95        = 0x403E,
    vqmonCODECVoiceAMRNB7k4         = 0x403F,
    vqmonCODECVoiceAMRNB6k7         = 0x4040,
    vqmonCODECVoiceAMRNB5k9         = 0x4041,
    vqmonCODECVoiceAMRNB5k15        = 0x4042,
    vqmonCODECVoiceAMRNB4k75        = 0x4043,
    vqmonCODECVoiceILBC13k3         = 0x4044,
    vqmonCODECVoiceILBC15k2         = 0x4045,
    vqmonCODECVoiceG711u56k         = 0x4046,
    vqmonCODECVoiceG711uPLC56k      = 0x4047,
    vqmonCODECVoiceG711A56k         = 0x4048,
    vqmonCODECVoiceG711APLC56k      = 0x4049,
    vqmonCODECVoiceG7231C           = 0x404A,
    vqmonCODECVoiceSpeex2k15        = 0x404B,
    vqmonCODECVoiceSpeex5k95        = 0x404C,
    vqmonCODECVoiceSpeex8k          = 0x404D,
    vqmonCODECVoiceSpeex11k         = 0x404E,
    vqmonCODECVoiceSpeex15k         = 0x404F,
    vqmonCODECVoiceSpeex18k2        = 0x4050,
    vqmonCODECVoiceSpeex24k6        = 0x4051,
    vqmonCODECVoiceSpeex3k95        = 0x4052,
    vqmonCODECVoiceSpeex12k8        = 0x4053,
    vqmonCODECVoiceSpeex16k8        = 0x4054,
    vqmonCODECVoiceSpeex20k6        = 0x4055,
    vqmonCODECVoiceSpeex23k8        = 0x4056,
    vqmonCODECVoiceSpeex27k8        = 0x4057,
    vqmonCODECVoiceSpeex34k2        = 0x4058,
    vqmonCODECVoiceSpeex42k2        = 0x4059,
    vqmonCODECVoiceBV16             = 0x405A,
    vqmonCODECVoiceBV32             = 0x405B,
    vqmonCODECVoiceIS54             = 0x405C,
    vqmonCODECVoicePDC6k7           = 0x405D,
    vqmonCODECVoiceAMBE2plus_2k4    = 0x405E,
    vqmonCODECVoiceAMBE2plus_3k2    = 0x405F,
    vqmonCODECVoiceAMBE2plus_4k     = 0x4060,
    vqmonCODECVoiceAMBE2plus_4k8    = 0x4061,
    
    vqmonCODECVoiceEVRCB            = 0x4062,
    
    vqmonCODECVoiceMSRTAudioWB      = 0x406A, /* 0x4062+8 */
    vqmonCODECVoiceMSRTAudioNB      = 0x406B,
    vqmonCODECVoiceMSRTAudioWBRED   = 0x406C,
    vqmonCODECVoiceMSRTAudioNBRED   = 0x406D,
    
    vqmonCODECVoiceGIPSG729         = 0x406E,

    /*
     * Silk
     */
    vqmonCODECVoiceSilkNB           = 0x406F,
    vqmonCODECVoiceSilkNBFEC        = 0x4070,
    vqmonCODECVoiceSilkMB           = 0x4071,
    vqmonCODECVoiceSilkMBFEC        = 0x4072,
    vqmonCODECVoiceSilkWB           = 0x4073,
    vqmonCODECVoiceSilkWBFEC        = 0x4074,
    vqmonCODECVoiceSilkSWB          = 0x4075,
    vqmonCODECVoiceSilkSWBFEC       = 0x4076,
    
    vqmonCODECVoiceEVRCWB           = 0x4077,
    
    vqmonCODECVoiceEVRCNW           = 0x407A, /* 0x4077+3 */

    vqmonCODECVoiceAMRWBP           = 0x4082, /* 0x4076+8 */

    /*
     * Siren7
     */
    vqmonCODECVoiceG7221_16k        = 0x4083,

    /*
     * Siren14
     */
    vqmonCODECVoiceG7221c_24k       = 0x4084,
    vqmonCODECVoiceG7221c_32k       = 0x4085,
    vqmonCODECVoiceG7221c_48k       = 0x4086,
    
    vqmonCODECVoiceG7221cLPR_24k    = 0x4087,
    vqmonCODECVoiceG7221cLPR_32k    = 0x4088,
    vqmonCODECVoiceG7221cLPR_48k    = 0x4089,

    /*
     * Siren22
     */
    vqmonCODECVoiceSiren22_32k      = 0x408A,
    vqmonCODECVoiceSiren22_48k      = 0x408B,
    vqmonCODECVoiceSiren22_64k      = 0x408C,
    
    vqmonCODECVoiceSiren22LPR_32k   = 0x408D,
    vqmonCODECVoiceSiren22LPR_48k   = 0x408E,
    vqmonCODECVoiceSiren22LPR_64k   = 0x408F,
    
    /*
     * G.719
     */
    vqmonCODECVoiceG719_32k         = 0x4090,
    vqmonCODECVoiceG719_48k         = 0x4091,
    vqmonCODECVoiceG719_64k         = 0x4092,

    /*
     * Opus
     */
    vqmonCODECVoiceOpusSilkNB       = 0x4093,
    vqmonCODECVoiceOpusSilkNBFEC    = 0x4094,
    vqmonCODECVoiceOpusSilkMB       = 0x4095,
    vqmonCODECVoiceOpusSilkMBFEC    = 0x4096,
    vqmonCODECVoiceOpusSilkWB       = 0x4097,
    vqmonCODECVoiceOpusSilkWBFEC    = 0x4098,
    vqmonCODECVoiceOpusHybridSWB    = 0x4099,
    vqmonCODECVoiceOpusHybridSWBFEC = 0x409A,
    vqmonCODECVoiceOpusHybridFB     = 0x409B,
    vqmonCODECVoiceOpusHybridFBFEC  = 0x409C,
    vqmonCODECVoiceOpusCeltNB       = 0x409D,
    vqmonCODECVoiceOpusCeltWB       = 0x409E,
    vqmonCODECVoiceOpusCeltSWB      = 0x409F,
    vqmonCODECVoiceOpusCeltFB       = 0x40A0,

    /*
     * EVS
     */
    vqmonCODECVoiceEvsNB            = 0x40A1,
    vqmonCODECVoiceEvsNBFEC         = 0x40A2,
    vqmonCODECVoiceEvsWB            = 0x40A3,
    vqmonCODECVoiceEvsWBFEC         = 0x40A4,
    vqmonCODECVoiceEvsSWB           = 0x40A5,
    vqmonCODECVoiceEvsSWBFEC        = 0x40A6,
    vqmonCODECVoiceEvsFB            = 0x40A7,
    vqmonCODECVoiceEvsFBFEC         = 0x40A8,
    
    /*
     *  L16 NB,SWB,FB
     */
    vqmonCODECVoiceL16NB            = 0x40A9,
    vqmonCODECVoiceL16NBPLC         = 0x40AA,
    vqmonCODECVoiceL16WB            = 0x40AB,
    vqmonCODECVoiceL16WBPLC         = 0x40AC,
    vqmonCODECVoiceL16SWB           = 0x40AD,
    vqmonCODECVoiceL16SWBPLC        = 0x40AE,
    vqmonCODECVoiceL16FB            = 0x40AF,
    vqmonCODECVoiceL16FBPLC         = 0x40B0,

    /*
     * G.722 with various PLC options
     */
    vqmonCODECVoiceG722_64k             = 0x40B1,
    vqmonCODECVoiceG722_56k             = 0x40B2,
    vqmonCODECVoiceG722_48k             = 0x40B3,
    vqmonCODECVoiceG722PLC3_64k         = 0x40B4,
    vqmonCODECVoiceG722PLC3_56k         = 0x40B5,
    vqmonCODECVoiceG722PLC3_48k         = 0x40B6,
    vqmonCODECVoiceG722PLC4_64k         = 0x40B7,
    vqmonCODECVoiceG722PLC4_56k         = 0x40B8,
    vqmonCODECVoiceG722PLC4_48k         = 0x40B9,

    /*
     * iSAC variable bitrate codec
     */
    vqmonCODECVoiceISACWB               = 0x40BA,
    vqmonCODECVoiceISACSWB              = 0x40BB,
    vqmonCODECVoiceISACWBNetEQ          = 0x40BC,
    vqmonCODECVoiceISACSWBNetEQ         = 0x40BD,
    vqmonCODECVoiceISACWBNetEQ4         = 0x40BE,
    vqmonCODECVoiceISACSWBNetEQ4        = 0x40BF,

    /*
     * AMR-VBR (NB,WB)
     */
    vqmonCODECVoiceAMRNB_VBR            = 0x40C0,
    vqmonCODECVoiceAMRWB_VBR            = 0x40C1,

    vqmonCODECVoiceMax,

    vqmonCODECVoiceDefaultNarrowband    = 0x4FF0,
    vqmonCODECVoiceDefaultWideband      = 0x4FF1,
    vqmonCODECVoiceDefaultSuperWideband = 0x4FF2,
    vqmonCODECVoiceDefaultFullband      = 0x4FF3,

    vqmonCODECVoiceSDPPktLoopback       = 0x4FF4,

    vqmonCODECVoiceUser1            = 0x4FFC,
    vqmonCODECVoiceUser2            = 0x4FFD,
    vqmonCODECVoiceUser3            = 0x4FFE,
    vqmonCODECVoiceUser4            = 0x4FFF,

    vqmonCODECVoiceLast

} vqmon_codecvoice_t;

/*
 * VQmon Voice Jitter Buffer Emulator Mode
 */
typedef enum
{
    /* Jitter Buffer Modes */

    vqmonJitterBufferModeTelchemy                = 0x0005,
    
    vqmonJitterBufferModeTelchemyFixed           = 0x0001,
    vqmonJitterBufferModeTelchemyReserved1       = 0x0002,
    vqmonJitterBufferModeTelchemyAdaptive2       = 0x0004,
    vqmonJitterBufferModeTelchemyReserved2       = 0x0008,
    vqmonJitterBufferModeTelchemyIgnoreDelay     = 0x0010,
    vqmonJitterBufferModeTelchemyIgnoreLoss      = 0x0020,
    vqmonJitterBufferModeTelchemyDisableDiscards = 0x0040,

    /* Jitter Buffer Attributes */

    vqmonJitterBufferAttrTelchemyJitterInc       = 0x8000

} vqmon_voicestrm_jbmode_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Voice-Specific Complex Data Types
 *
 * --------------------------------------------------------------------------
 */
typedef enum
{
    vqmonVoiceMOSReferenceNarrowband = 0,
    vqmonVoiceMOSReferenceMediumband,
    vqmonVoiceMOSReferenceWideband,
    vqmonVoiceMOSReferenceUltraWideband,
    vqmonVoiceMOSReferenceSuperWideband,
    vqmonVoiceMOSReferenceFullband

} vqmon_voicestream_moscontext_t;


typedef enum
{
    vqmonVoiceMOSScaleACR    = 0,
    vqmonVoiceMOSScaleG107,
    vqmonVoiceMOSScaleJapanTTC

} vqmon_voicestream_mosscale_t;


/*
 * VQmon voice stream interface statistics.
 */
struct _vqmon_interfacestats_voicestrm_s
{
    tcmyU32                     nStreamsActive;
    tcmyU32                     nStreamsTerminated;

    tcmyU64                     nPktsRcvd;
    tcmyU64                     nPktsLost;
    tcmyU64                     nPktsDiscarded;

    vqmon_rfactor_t             nMinR_LQ;
    vqmon_rfactor_t             nAvgR_LQ;
    vqmon_rfactor_t             nMaxR_LQ;

    vqmon_rfactor_t             nMinR_G107;
    vqmon_rfactor_t             nAvgR_G107;
    vqmon_rfactor_t             nMaxR_G107;

    vqmon_mos_t                 nMinMOS_LQ;
    vqmon_mos_t                 nAvgMOS_LQ;
    vqmon_mos_t                 nMaxMOS_LQ;

    vqmon_rfactor_t             nMinR_CQ;
    vqmon_rfactor_t             nAvgR_CQ;
    vqmon_rfactor_t             nMaxR_CQ;

    vqmon_mos_t                 nMinMOS_CQ;
    vqmon_mos_t                 nAvgMOS_CQ;
    vqmon_mos_t                 nMaxMOS_CQ;

    
};

typedef struct _vqmon_interfacestats_voicestrm_s \
    vqmon_interfacestats_voicestrm_t;

/*
 * VQmon voice stream general configuration
 */
struct _vqmon_streamcfg_voicegencfg_s
{
    vqmon_voicestream_mosscale_t    eMOSScale;
    vqmon_voicestream_moscontext_t  eMOSContext;
};
typedef struct _vqmon_streamcfg_voicegencfg_s \
    vqmon_streamcfg_voicegencfg_t;

/*
 * VQmon voice stream G107 params configuration
 */
struct _vqmon_streamcfg_voiceG107params_s
{
    tcmyS16        nNo;
    tcmyU16        nT;
    tcmyU16        nTa;
    tcmyU16        nTr;
    tcmyS8         nSLR;
    tcmyS8         nRLR;
    tcmyU8         nSTMR;
    tcmyU8         nTELR;
    tcmyU8         nWEPL;
    tcmyU8         nIe;
    tcmyU16        nBpl;
    tcmyU16        nPpl;
    tcmyU8         nA;
    tcmyS8         nLocalSLR;

    tcmyS8         nNc;
    tcmyU8         nPr;
    tcmyS8         nDr;
    tcmyU8         nPs;
    tcmyS8         nDs;
};
typedef struct _vqmon_streamcfg_voiceG107params_s \
     vqmon_streamcfg_voiceG107params_t;

struct _vqmon_streamcfg_rtppktdur_s
{
    /*
     * RTP Packet duration in microseconds
     */
    tcmyU32         nPktDurUsec;
};
typedef struct _vqmon_streamcfg_rtppktdur_s vqmon_streamcfg_rtppktdur_t;

/*
 * VQmon voice stream Analog Metrics configuration
 */
struct _vqmon_streamcfg_voiceanalogmetrics_s
{
    tcmyS16                     nNoiseLevel_dBm;
    tcmyS16                     nLocalSignalLevel_dBm;
    tcmyS16                     nLocalRERL_dB;
    tcmyS16                     nRemoteRERL_dB;
    tcmyS16                     nRemoteSignalLevel_dBm;
};
typedef struct _vqmon_streamcfg_voiceanalogmetrics_s
    vqmon_streamcfg_voiceanalogmetrics_t;

/*
 * VQmon voice stream XR Decode configuration
 */
struct _vqmon_streamcfg_voicertcppktusage_s
{
    tcmyBOOL  bAllowXRAnalogMetricsUpdate;
    tcmyBOOL  bAllowXRJitterBufferUpdate;
};
typedef struct _vqmon_streamcfg_voicertcppktusage_s
    vqmon_streamcfg_voicertcppktusage_t;

/*
 * VQmon voice stream Jitter Buffer Configuration
 */

struct _vqmon_streamcfg_voicejitterbuffer_s
{
    vqmon_voicestrm_jbmode_t          eMode;
    tcmyU16                           nMinDelay;
    tcmyU16                           nNomDelay;
    tcmyU16                           nMaxDelay;  
};
typedef struct _vqmon_streamcfg_voicejitterbuffer_s
        vqmon_streamcfg_voicejitterbuffer_t;

struct _vqmon_streamcfg_voiceesdelay_s
{
    tcmyS16                         nOrigESDelayMs;
    tcmyS16                         nTermESDelayMs;
};
typedef struct _vqmon_streamcfg_voiceesdelay_s vqmon_streamcfg_voiceesdelay_t;

/*
 * VQmon voice stream CODEC preference configuration
 */
struct _vqmon_streamcfg_voicecodecpref_s
{
    tcmyU16                 nCount;
    vqmon_codecid_t         aCODEC[1];
};

typedef struct _vqmon_streamcfg_voicecodecpref_s
            vqmon_streamcfg_voicecodecpref_t;


struct _vqmon_streammetrics_voicejitter_s
{
    vqmon_fpq4_t                    nAvgMAPDV_Ms;
    vqmon_fpq4_t                    nMaxAvgMAPDV_Ms;
};
typedef struct _vqmon_streammetrics_voicejitter_s 
    vqmon_streammetrics_voicejitter_t;

struct _vqmon_streammetrics_voiceanalog_s
{
    tcmyS16                    nNoiseLevel_dBm;
    vqmon_streammetricsource_t eNoiseLevelSource;

    tcmyS16                    nSignalLevel_dBm;
    vqmon_streammetricsource_t eSignalLevelSource;

    tcmyS16                    nLocalRERL_dB;
    vqmon_streammetricsource_t eLocalRERLSource;

    tcmyS16                    nRemoteRERL_dB;
    vqmon_streammetricsource_t eRemoteRERLSource;

    tcmyS16                    nRemoteSignalLevel_dBm;
    vqmon_streammetricsource_t eRemoteSignalLevelSource;
};

typedef struct _vqmon_streammetrics_voiceanalog_s 
    vqmon_streammetrics_voiceanalog_t;

/*
 * VQmon stream voice perceptual quality metrics block.
 */
struct _vqmon_streammetrics_voicequal_s
{
    tcmyU8                         nR_LQ;
    tcmyU8                         nR_CQ;
    tcmyU8                         nR_G107;
    tcmyU8                         nR_Nom;
    vqmon_mos_t                    nMOS_LQ;
    vqmon_mos_t                    nMOS_CQ;
    vqmon_mos_t                    nMOS_Nom;
    vqmon_voicestream_mosscale_t   eMOSScale;
    vqmon_voicestream_moscontext_t eMOSContext;
    tcmyU8                         nBurstR;
    tcmyU8                         nGapR;
    tcmyU16                        nBurstExcessMs;
    tcmyU16                        nGapExcessMs;
    tcmyU32                        nAvgBurstLenMs;
    tcmyU32                        nAvgGapLenMs;
    tcmyU32                        nAvgVoiceBW;

    struct
    {
        vqmon_degsevlvl_t       nLossDeg;
        vqmon_degsevlvl_t       nDiscardDeg;
        vqmon_degsevlvl_t       nVocoderDeg;
        vqmon_degsevlvl_t       nDelayDeg;
        vqmon_degsevlvl_t       nSignalLvlDeg;
        vqmon_degsevlvl_t       nNoiseLvlDeg;
        vqmon_degsevlvl_t       nEchoLvlDeg;
        vqmon_degsevlvl_t       nRecencyDeg;
    } deg_factors;

};

typedef struct _vqmon_streammetrics_voicequal_s vqmon_streammetrics_voicequal_t;


struct _vqmon_streammetrics_voicexr_s
{
    tcmyU8                      nLossRate;
    tcmyU8                      nDiscardRate;
    tcmyU8                      nAvgBurstDensity;
    tcmyU8                      nAvgGapDensity;
    tcmyU16                     nAvgBurstDuration;
    tcmyU16                     nAvgGapDuration;
    tcmyU16                     nRTDelayMs;
    tcmyU16                     nEndSystemDelayMs;
    tcmyS8                      nSignalLevel_dBm;
    tcmyS8                      nNoiseLevel_dBm;
    tcmyU8                      nRERL_dB;
    tcmyU8                      nMinGapSize;
    tcmyU8                      nRFactor;
    tcmyU8                      nExtRFactor;
    tcmyU8                      nMOS_LQ;
    tcmyU8                      nMOS_CQ;
    tcmyU8                      fRXConfig;
    tcmyU16                     nJBNomDelayMs;
    tcmyU16                     nJBMaxDelayMs;
    tcmyU16                     nJBAbsMaxDelayMs;
};

typedef struct _vqmon_streammetrics_voicexr_s vqmon_streammetrics_voicexr_t;

struct _vqmon_streammetrics_voicedatametrics_s
{
    tcmyU16                     nThroughPutIndex;
    tcmyU16                     nReliabilityIndex;
};

typedef struct _vqmon_streammetrics_voicedatametrics_s 
    vqmon_streammetrics_voicedatametrics_t;

struct _vqmon_streammetrics_voiceinterval_s
{
    vqmon_time_t                tStartTime;
    vqmon_time_t                tEndTime;
    tcmyU32                     nPacketsReceived;
    tcmyU32                     nPacketsCorrected;
    tcmyU32                     nPacketsLost;
    tcmyU32                     nPacketsDiscarded;
    tcmyU32                     nPktsOutOfSeq;
    tcmyU32                     nPktsDuplicated;
    vqmon_percent_t             nAvgLossRate;

    vqmon_ufpq4_t               nPPDVMs;

    tcmyU8                      nR_CQ;
    tcmyU8                      nR_LQ;
    vqmon_mos_t                 nMOS_LQ;
    vqmon_mos_t                 nMOS_CQ;

    tcmyU32                     nAvgVoiceBW;
};
typedef struct _vqmon_streammetrics_voiceinterval_s
    vqmon_streammetrics_voiceinterval_t;


/*
 * VQmon RTCP SR/XR based QoE metrics
 */
struct _vqmon_streammetrics_voicertcpqual_s
{
    vqmon_mos_t                 nPMOS_LQ;
    vqmon_mos_t                 nPMOS_CQ;
    vqmon_streammetricsource_t  eMetricsSource;
};

typedef struct _vqmon_streammetrics_voicertcpqual_s
    vqmon_streammetrics_voicertcpqual_t;


/* --------------------------------------------------------------------------
 *
 *      VQmon Public Voice Stream Functions
 *
 * --------------------------------------------------------------------------
 */

VQMON_PUBLIC(vqmon_result_t)
VQmonVocoderNominalQualityScore(
    vqmon_codecvoice_t  eVocoderType,
    vqmon_voicestream_mosscale_t eMOSScale,
    vqmon_voicestream_moscontext_t *pMOSContext,
    tcmyU8              *pNominalRFactor,
    vqmon_mos_t         *pNominalMOS
    );


#ifdef __cplusplus
}
#endif

#endif  /* _TELCHEMY_VQMONVCD_H_ */
